import javafx.beans.Observable;
import javafx.beans.property.*;
import javafx.collections.*;

class ObservableListUpdates {
	public static void main(String[] args) {
		ObservableList<StringProperty> ols = FXCollections.observableArrayList(e -> new Observable[] {e});
		
		ols.addListener(new ListChangeListener<StringProperty>() {
			@Override
			public void onChanged(ListChangeListener.Change<? extends StringProperty> c) {
				while (c.next()) {
					if (c.wasAdded())
						System.out.println("Ergänzt: " + c.getAddedSubList());
					if (c.wasUpdated()) {
						int i = c.getFrom();
						System.out.println("Neuer Wert von Element " + i + ": " +
								           c.getList().get(i).get());
					}
				}
			}
		});
		
		StringProperty spa = new SimpleStringProperty("A");
		StringProperty spb = new SimpleStringProperty("B");
		
		System.out.println("\nElemente aufnehmen:");
		ols.addAll(spa, spb);

		System.out.println("\nEin Element ändern:");
		ols.get(1).set("B1");
	}
}
